## **Device Trajectory Overview**

### **What is Device Trajectory?**

- A feature in the Cisco Secure Endpoint console that provides **retrospective security** for endpoints.
- Tracks and displays the interaction of processes on an endpoint running the Cisco Secure Endpoint connector or **Clarity for iOS**.
- Offers a **historic view** of processes, files, network connections, and Indicators of Compromise (IOCs) on the device.

---

### **Use Case Example:**

- Suppose malware from the CryptoWall campaign is detected and cleaned from an endpoint.
- **Device Trajectory** can trace how the malware was delivered to the endpoint, allowing you to identify its entry point and spread.

---

### **Graphical Representation in Device Trajectory:**

![[Pasted image 20250525160940.png]]

- **Y-Axis (Left):** Lists system processes on the endpoint.
- **X-Axis (Bottom):** Represents a scrollable timeline.
- **Markers:** Circular markers represent specific events. Clicking on them provides contextual information about the device's behavior at that point in time.

---

### **Example Investigation Workflow:**

1. **Identify Indicators of Compromise:**
    
    - `msiexec.exe` connects to a webpage associated with the CryptoWall campaign.
    - `svchost.exe` accesses suspicious WordPress websites linked to the campaign.
2. **Trace Back Process Activity:**
    
    - `svchost.exe` was executed by `explorer.exe`.
    - `explorer.exe` was executed by `kb260650230.exe`.
    - `msiexec.exe` was created and executed by the same random file (`kb260650230.exe`).
    - `msiexec.exe` originated from `tempdocumento0923.exe`.
    - Tracing further reveals `winword.exe` (Microsoft Word) executed `tempdocumento0923.exe`, indicating that Word was likely used to open a macro-laced document.
3. **Retrospective Insights:**
    
    - Using device trajectory, you can identify suspicious processes like `msiexec.exe` running malicious code and trace their origins.
    - This highlights compromised applications (e.g., Microsoft Word) and malware entry points.

---

### **Key Features of Device Trajectory:**

- Tracks endpoint activity **independently of IP subnets or hostnames** using an embedded Client ID in the connector.
- Provides an **accurate historical view** of local process activity even if the endpoint changes networks or hostnames.

---

## **File Trajectory Overview**

### **What is File Trajectory?**

- Tracks the lifecycle of files within the Cisco Secure Endpoint environment.
- Provides retrospective security by showing:
    - **Where and when a file was detected.**
    - **Which computers in the network have seen the file.**
    - **Actions taken by the file, including files created or executed by it.**

---

### **Key Features of File Trajectory:**

- Displays the **entire lifecycle** of a file, from the first detection to the last, across all endpoints in the network.
- Shows parent processes or files responsible for introducing the threat into the network.
- Tracks file activity even if antivirus software on the endpoint is later disabled.

---

### **Example Use Case:**

- File trajectory can identify:
    - The initial endpoint where a malicious file was detected.
    - Other endpoints where the file has propagated.
    - Parent processes that introduced the file into the network.

---

## **Combining Device and File Trajectory**

- **Device Trajectory:**
    
    - Focuses on process and system-level activity on a single endpoint.
    - Helps trace how malware entered and spread on a specific device.
- **File Trajectory:**
    
    - Tracks the movement and lifecycle of files across multiple endpoints or within a single endpoint.
    - Identifies the scope of infection and the origin of malicious files.
- **Together:**
    
    - Quickly identify the source of malware.
    - Determine if any endpoints in the network still contain the malware for faster remediation.

---

### **Key Takeaways**

- **Device Trajectory:** Helps investigate how malware entered and spread through processes on a specific endpoint.
- **File Trajectory:** Tracks the lifecycle and movement of malicious files across the network.
- Using both features in tandem provides comprehensive visibility, enabling rapid malware identification, containment, and remediation.